<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\capacity;
use App\Models\pertap;
use App\Models\Ticket;

class TellUser extends Model
{
    use HasFactory;
    protected $fillable = [
        'tell_id',
        'govern_amount', // gov Token
        'local_amount',  // local token
        'ref_limit',     // limit of subs that it can have!
        'used_ref',      // subs count
        'ref_json',      // json for save {subId : geted Earn! : local gov}
        'capaciy_id',   // id of users daily cap
        'pertap_id',    // perTap factor : {1,2,3,...}
        'daily_charge_id',
        'daily_spin_id', // shows todays spin : 1: free 2nd : 100T 3rd 100T+whatchAds
        'today_charge',  // todays taps * pertaps!
        'status',
        'isBan',
        'is_watched',    // watched adds or not
        'is_used_spin',   // isUsed this spin or not!
        'ref_id',        // referal id of super user!
        'get_reward',
        'last_tap',
        'task'
    ];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->capacity_id)) {
                $model->capacity_id = 1; // Or any default value
            }
            if (is_null($model->pertap_id)) {
                $model->pertap_id = 1; // Or any default value
            }
            if (is_null($model->daily_charge_id)) {
                $model->daily_charge_id = 1; // Or any default value
            }
            if (is_null($model->daily_spin_id)) {
                $model->daily_spin_id = 1; // Or any default value
            }
        });
    }

    public function capacity()
    {
        return $this->belongsTo(Capacity::class);
    }

    public function pertap()
    {
        return $this->belongsTo(pertap::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }
}
