<?php
///todo list : last tap time , referal

namespace App\Http\Controllers;

use App\Models\tellUser;
use Carbon\Carbon;
use Illuminate\Http\Request;

class TellUserController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $tellUsers = tellUser::getAll();
        return response()->json([
            "error" => false,
            "tellUsers" => $tellUsers
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function register(Request $request)
    {
        //

        try {
            $request->validate(
                [
                    'tellId' => ['required'],
                    'refId' => ['required']
                ]
            );
            $tellId = $request->input('tellId');
            $refId = $request->input('refId');

            $newTellUser = new tellUser([
                'tell_id' => $tellId,
                'ref_id' => $refId,
            ]);
            $newTellUser->save();
            $newTellUser = tellUser::find($newTellUser->id);
            $refUser = tellUser::whereTellId($refId)->get()->first(); //first();
            if ($refUser->refLimit < $refUser->usedRef) {
                return response()->json([
                    "error" => false,
                    "tellUser" => $newTellUser,
                    "refUser" => $$refUser,
                    "message" => "done"
                ]);
            }

            return response()->json([
                "error" => false,
                "tellUser" => $newTellUser,
                "message" => "done"
            ]);
        } catch (\Throwable $th) {
            return response()->json(["error" => true, "message" => "Cant create"], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );
        $tellId = $request->input('tellId');
        $thisTellUser = tellUser::whereTellId($tellId)->get()->first();
        $nowCarbon = Carbon::now();
        $lastTap = Carbon::parse($thisTellUser->last_tap);
        if (!$lastTap->isSameDay($nowCarbon->addDay())) {
            $thisTellUser->today_charge = 0;
        }
        if ($thisTellUser) {
            return response()->json([
                "error" => false,
                "tellUser" => $thisTellUser,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function askReward(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
            ]
        );
        $tellId = $request->input('tellId');
        $thisTellUser = tellUser::whereTellId($tellId)->get()->first();
        if ($thisTellUser->get_reward == 0) {

            $thisTellUser->local_amount += 10;
            $thisTellUser->save();
        } else {
            return response()->json(["error" => true, "message" => "Geted reward before!"], 203);
        }
    }

    /**
     * Display the specified resource.
     */
    public function showViaId(int $id)
    {
        $thisTellUser = tellUser::whereId($id)->get();
        if ($thisTellUser) {
            return response()->json([
                "error" => false,
                "tellUser" => $thisTellUser,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(tellUser $tellUser)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],
                    'id' => ['required'],

                ]
            );
            $id = $request->input('id');
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newTellUser = tellUser::whereId($id)->get();
            $newTellUser->level = $level;
            $newTellUser->capacity = $capacity;
            $res = $newTellUser->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "tellUser" => $newTellUser,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function setTaps(Request $request)
    {
        $request->validate(
            [
                'tellId' => ['required'],
                'tap' => ['required'],
            ]
        );

        $tellId = $request->input('tellId');
        $tap = $request->input('tap');

        $newTellUser = tellUser::whereTellId($tellId)->get()->first(); //first()
        $nowCarbon = Carbon::now();
        $lastTap = Carbon::parse($newTellUser->last_tap);
        if (!$lastTap->isSameDay($nowCarbon->addDay())) {
            $newTellUser->today_charge = 0;
        }
        if ($newTellUser->today_charge < $newTellUser->capacity->capacity) {
            $value = $newTellUser->today_charge + $tap * $newTellUser->pertap->capacity;
            if ($value > $newTellUser->capacity->capacity) {
                $value = $newTellUser->capacity->capacity;
            }
            $income = $value -  $newTellUser->today_charge;
            $newTellUser->today_charge = $value;
            $newTellUser->local_amount += $income;
            $newTellUser->last_tap = $nowCarbon;

            $newTellUser->save();
            return response()->json(["error" => false, "message" => "updated", "user" => $newTellUser, "value" => $value], 200);
        } else {
            return response()->json(["error" => true, "message" => "todays capacity is over", "user" => $newTellUser], 202);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'id' => ['required'],
                ]
            );
            $id =  $request->input('id');
            $res = tellUser::whereId($id)->delete();
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }
}
