<?php

namespace App\Http\Controllers;

use App\Models\dailyCharge;
use Illuminate\Http\Request;

class DailyChargeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $dailyCharges = dailyCharge::getAll();
        return response()->json([
            "error" => false,
            "dailyCharges" => $dailyCharges
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],

                ]
            );
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newDailyCharge = new dailyCharge([
                'level' => $level,
                'capacity' => $capacity,
            ]);
            $res = $newDailyCharge->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "dailyCharge" => $newDailyCharge,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(int $id)
    {
        $thisCap = dailyCharge::whereId($id)->get();
        if ($thisCap) {
            return response()->json([
                "error" => false,
                "dailyCharge" => $thisCap,
                "message" => "done"
            ]);
        } else {
            return response()->json(["error" => true, "message" => "Cant find"], 203);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(dailyCharge $dailyCharge)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'level' => ['required'],
                    'capacity' => ['required'],
                    'id' => ['required'],

                ]
            );
            $id = $request->input('id');
            $level = $request->input('level');
            $capacity = $request->input('capacity');

            $newDailyCharge = dailyCharge::whereId($id)->get();
            $newDailyCharge->level = $level;
            $newDailyCharge->capacity = $capacity;
            $res = $newDailyCharge->save();
            if ($res) {
                return response()->json([
                    "error" => false,
                    "dailyCharge" => $newDailyCharge,
                    "message" => "done"
                ]);
            } else {
                return response()->json(["error" => true, "message" => "Cant create"], 203);
            }
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        if ($request->user()->tokenCan('admin')) {
            $request->validate(
                [
                    'id' => ['required'],
                ]
            );
            $id =  $request->input('id');
            $res = dailyCharge::whereId($id)->delete();
            return response()->json([
                "error" => false,
                "message" => "removed successfully. "
            ], 200);
        } else {
            return response()->json([
                "error" => true,
                "message" => "unauthenticated. "
            ], 400);
        }
    }
}
